#pragma once

#include <windows.h>
#include <dbt.h>
#include "resource.h"

// This GUID is for all USB serial host PnP drivers
GUID WceusbshGUID = { 0x25dbce51, 0x6c8f, 0x4a72, 0x8a,0x6d,0xb5,0x4c,0x2b,0x4f,0xc8,0x35 };
HDEVNOTIFY DoRegisterDeviceInterfaceToHwnd( GUID InterfaceClassGuid, HWND hWnd ) {
	HDEVNOTIFY hDeviceNotify;
	DEV_BROADCAST_DEVICEINTERFACE NotificationFilter;

	ZeroMemory(&NotificationFilter, sizeof(NotificationFilter));
	NotificationFilter.dbcc_size = sizeof(DEV_BROADCAST_DEVICEINTERFACE);
	NotificationFilter.dbcc_devicetype = DBT_DEVTYP_DEVICEINTERFACE;
	NotificationFilter.dbcc_classguid = InterfaceClassGuid;

	hDeviceNotify = RegisterDeviceNotification(
		hWnd,                       // events recipient
		&NotificationFilter,        // type of device
		DEVICE_NOTIFY_WINDOW_HANDLE // type of recipient handle
		);

	return hDeviceNotify;
}

namespace MFMeter2 {

	using namespace System;
	using namespace System::ComponentModel;
	using namespace System::Collections;
	using namespace System::Windows::Forms;
	using namespace System::Data;
	using namespace System::Drawing;
	using namespace System::Drawing::Printing;	//added manually
	using namespace System::IO;					// likewise
	using namespace System::IO::Ports;			// likewise
	using namespace System::Threading;          // and ditto  <--  

												/// <summary>
												/// Summary for MyForm
												/// </summary>

	HKEY RegOpenKey(HKEY hRootKey, wchar_t* strKey) {
		HKEY hKey = 0;
		RegCreateKeyEx(hRootKey, strKey, NULL, NULL, 0, KEY_ALL_ACCESS, NULL, &hKey, NULL);
		return hKey;
	}

	bool RegGetCharVal(HKEY Key, wchar_t* StringName, wchar_t* toHere, DWORD length) {
		DWORD dwType = REG_SZ;
		toHere[0] = L'\0';
		return RegQueryValueEx(Key, StringName, NULL, &dwType, (LPBYTE)toHere, &length) == ERROR_SUCCESS;
	}

	public ref class MyForm3 : public System::Windows::Forms::Form
	{
	public: PrintDocument ^printDocument1 = gcnew PrintDocument();	// added to get form print going
			String^ stringToPrint;
			System::Drawing::Font^ fontToUse;

	private: System::Threading::Thread^ samplingThread;				// added for threading <--
	private: System::Windows::Forms::Timer^ samplingTimer = gcnew System::Windows::Forms::Timer;
	private: HWND myHWND;
	private: HDEVNOTIFY hDeviceNotify;

	public:
		MyForm3(void)
		{
			// Silicon Chip 24-bit Arduino based Measuring System App V1.0
			// written by Jim Rowe in MS Visual Studio C++ Prof 2013
			// and Nicholas Vinen in MS Visual Studio C++ 2015
			// Last revised 15/03/2016 at 10:30 am
			wchar_t temp[128];

			HICON hicon = LoadIcon(GetModuleHandle(NULL), MAKEINTRESOURCE(IDI_ICON1));
			this->Icon = System::Drawing::Icon::FromHandle((IntPtr)hicon);

			InitializeComponent();

			HKEY key = RegOpenKey(HKEY_CURRENT_USER, L"SOFTWARE\\SCArduinoMFM");
			if (key) {
				if (RegGetCharVal(key, L"SerialPort", temp, sizeof(temp) - 1)) {
					String^ s = gcnew String(temp);
					this->comboBox1->Text = s;
				}
				if (RegGetCharVal(key, L"BaudRate", temp, sizeof(temp) - 1)) {
					String^ s = gcnew String(temp);
					this->comboBox2->Text = s;
				}
				if (RegGetCharVal(key, L"LoadImpedance", temp, sizeof(temp) - 1)) {
					String^ s = gcnew String(temp);
					this->comboBox3->Text = s;
				}
				if (RegGetCharVal(key, L"SamplingInterval", temp, sizeof(temp) - 1)) {
					String^ s = gcnew String(temp);
					this->comboBox4->Text = s;
				}
				RegCloseKey(key);
			}

			findPorts();
			this->myHWND = static_cast<HWND>(this->Handle.ToPointer());
			hDeviceNotify = DoRegisterDeviceInterfaceToHwnd(WceusbshGUID, this->myHWND);
		}

	protected:
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		~MyForm3()
		{
			if (this->samplingThread && this->samplingThread->IsAlive) //<--
				this->samplingThread->Abort();	//<--
			delete components;
			UnregisterDeviceNotification(this->hDeviceNotify);
		}
	protected: void OnClose() {
		HKEY key = RegOpenKey(HKEY_CURRENT_USER, L"SOFTWARE\\SCArduinoMFM");
		if (key) {
			IntPtr tstr = System::Runtime::InteropServices::Marshal::StringToHGlobalUni(this->comboBox1->Text);
			LPCWSTR temp = (LPCWSTR)tstr.ToPointer();
			RegSetValueEx(key, L"SerialPort", 0, REG_SZ, (const BYTE*)temp, wcslen(temp)*sizeof(*temp));
			System::Runtime::InteropServices::Marshal::FreeHGlobal(tstr);

			tstr = System::Runtime::InteropServices::Marshal::StringToHGlobalUni(this->comboBox2->Text);
			temp = (LPCWSTR)tstr.ToPointer();
			RegSetValueEx(key, L"BaudRate", 0, REG_SZ, (const BYTE*)temp, wcslen(temp)*sizeof(*temp));
			System::Runtime::InteropServices::Marshal::FreeHGlobal(tstr);

			tstr = System::Runtime::InteropServices::Marshal::StringToHGlobalUni(this->comboBox3->Text);
			temp = (LPCWSTR)tstr.ToPointer();
			RegSetValueEx(key, L"LoadImpedance", 0, REG_SZ, (const BYTE*)temp, wcslen(temp)*sizeof(*temp));
			System::Runtime::InteropServices::Marshal::FreeHGlobal(tstr);

			tstr = System::Runtime::InteropServices::Marshal::StringToHGlobalUni(this->comboBox4->Text);
			temp = (LPCWSTR)tstr.ToPointer();
			RegSetValueEx(key, L"SamplingInterval", 0, REG_SZ, (const BYTE*)temp, wcslen(temp)*sizeof(*temp));
			System::Runtime::InteropServices::Marshal::FreeHGlobal(tstr);

			RegCloseKey(key);
		}
	}

	private: System::Windows::Forms::MenuStrip^  menuStrip1;
	protected:
	private: System::Windows::Forms::ToolStripMenuItem^  fileToolStripMenuItem;
	private: System::Windows::Forms::ToolStripMenuItem^  openToolStripMenuItem;
	private: System::Windows::Forms::ToolStripMenuItem^  saveToolStripMenuItem;
	private: System::Windows::Forms::ToolStripMenuItem^  exitToolStripMenuItem;
	private: System::Windows::Forms::ToolStripMenuItem^  aboutToolStripMenuItem;
	private: System::Windows::Forms::ComboBox^  comboBox1;
	private: System::Windows::Forms::Label^  label1;
	private: System::Windows::Forms::Label^  label2;
	private: System::Windows::Forms::ComboBox^  comboBox2;
	private: System::Windows::Forms::Button^  button1;
	private: System::Windows::Forms::Button^  button2;
	private: System::IO::Ports::SerialPort^  serialPort1;
	private: System::Windows::Forms::TextBox^  textBox1;
	private: System::Windows::Forms::Label^  label3;
	private: System::Windows::Forms::TextBox^  textBox2;
	private: System::ComponentModel::IContainer^  components;
	private: System::Windows::Forms::ComboBox^  comboBox3;
	private: System::Windows::Forms::ComboBox^  comboBox4;
	private: System::Windows::Forms::CheckBox^  checkBox1;

	private:
		/// <summary>
		volatile bool ContSampling = false;	// continuous sampling flag (false = single sample)
		volatile bool SampActive = false;	// sampling active or not flag (true = sampling in progress)
		volatile bool AbortSampling = false;
		volatile Int16 SintBox1 = 0;		// used to save num of samples taken & shown in textBox1
		volatile bool LiveReading = false;
		volatile bool LiveReadingOnly = false;
		volatile bool SuppressCloseMessage = false;
		volatile bool SerialPortOpen = false;
		Int32 SamplingIntervalMilliseconds = 500;

	private: System::Windows::Forms::SaveFileDialog^  saveFileDialog1;
	private: System::Windows::Forms::OpenFileDialog^  openFileDialog1;
	private: System::Windows::Forms::Label^  label4;
	private: System::Windows::Forms::Label^  label5;
	private: System::Windows::Forms::ToolStripMenuItem^  newToolStripMenuItem;
	private: System::Windows::Forms::ToolStripMenuItem^  printToolStripMenuItem;
	private: System::Windows::Forms::PrintDialog^  printDialog1;

			 /// </summary>


#pragma region Windows Form Designer generated code
			 /// <summary>
			 /// Required method for Designer support - do not modify
			 /// the contents of this method with the code editor.
			 /// </summary>
			 void InitializeComponent(void)
			 {
				 this->components = (gcnew System::ComponentModel::Container());
				 this->menuStrip1 = (gcnew System::Windows::Forms::MenuStrip());
				 this->fileToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
				 this->newToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
				 this->openToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
				 this->saveToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
				 this->printToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
				 this->exitToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
				 this->aboutToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
				 this->comboBox1 = (gcnew System::Windows::Forms::ComboBox());
				 this->label1 = (gcnew System::Windows::Forms::Label());
				 this->label2 = (gcnew System::Windows::Forms::Label());
				 this->comboBox2 = (gcnew System::Windows::Forms::ComboBox());
				 this->button1 = (gcnew System::Windows::Forms::Button());
				 this->button2 = (gcnew System::Windows::Forms::Button());
				 this->serialPort1 = (gcnew System::IO::Ports::SerialPort(this->components));
				 this->textBox1 = (gcnew System::Windows::Forms::TextBox());
				 this->label3 = (gcnew System::Windows::Forms::Label());
				 this->textBox2 = (gcnew System::Windows::Forms::TextBox());
				 this->saveFileDialog1 = (gcnew System::Windows::Forms::SaveFileDialog());
				 this->openFileDialog1 = (gcnew System::Windows::Forms::OpenFileDialog());
				 this->label4 = (gcnew System::Windows::Forms::Label());
				 this->label5 = (gcnew System::Windows::Forms::Label());
				 this->comboBox3 = (gcnew System::Windows::Forms::ComboBox());
				 this->comboBox4 = (gcnew System::Windows::Forms::ComboBox());
				 this->printDialog1 = (gcnew System::Windows::Forms::PrintDialog());
				 this->checkBox1 = (gcnew System::Windows::Forms::CheckBox());
				 this->menuStrip1->SuspendLayout();
				 this->SuspendLayout();

				 // 
				 // menuStrip1
				 // 
				 this->menuStrip1->Items->AddRange(gcnew cli::array< System::Windows::Forms::ToolStripItem^  >(2) {
					 this->fileToolStripMenuItem,
						 /*this->configureToolStripMenuItem, */this->aboutToolStripMenuItem
				 });
				 this->menuStrip1->Location = System::Drawing::Point(0, 0);
				 this->menuStrip1->Name = L"menuStrip1";
				 this->menuStrip1->Size = System::Drawing::Size(953, 24);
				 this->menuStrip1->TabIndex = 0;
				 this->menuStrip1->Text = L"menuStrip1";
				 // 
				 // fileToolStripMenuItem
				 // 
				 this->fileToolStripMenuItem->DropDownItems->AddRange(gcnew cli::array< System::Windows::Forms::ToolStripItem^  >(5) {
					 this->newToolStripMenuItem,
						 this->openToolStripMenuItem, this->saveToolStripMenuItem, this->printToolStripMenuItem, this->exitToolStripMenuItem
				 });
				 this->fileToolStripMenuItem->Name = L"fileToolStripMenuItem";
				 this->fileToolStripMenuItem->Size = System::Drawing::Size(37, 20);
				 this->fileToolStripMenuItem->Text = L"&File";
				 // 
				 // newToolStripMenuItem
				 // 
				 this->newToolStripMenuItem->Name = L"newToolStripMenuItem";
				 this->newToolStripMenuItem->Size = System::Drawing::Size(103, 22);
				 this->newToolStripMenuItem->Text = L"&New";
				 this->newToolStripMenuItem->Click += gcnew System::EventHandler(this, &MyForm3::newToolStripMenuItem_Click);
				 // 
				 // openToolStripMenuItem
				 // 
				 this->openToolStripMenuItem->Name = L"openToolStripMenuItem";
				 this->openToolStripMenuItem->Size = System::Drawing::Size(103, 22);
				 this->openToolStripMenuItem->Text = L"&Open";
				 this->openToolStripMenuItem->Click += gcnew System::EventHandler(this, &MyForm3::openToolStripMenuItem_Click);
				 // 
				 // saveToolStripMenuItem
				 // 
				 this->saveToolStripMenuItem->Name = L"saveToolStripMenuItem";
				 this->saveToolStripMenuItem->Size = System::Drawing::Size(103, 22);
				 this->saveToolStripMenuItem->Text = L"&Save As";
				 this->saveToolStripMenuItem->Click += gcnew System::EventHandler(this, &MyForm3::saveToolStripMenuItem_Click);
				 // 
				 // printToolStripMenuItem
				 // 
				 this->printToolStripMenuItem->Name = L"printToolStripMenuItem";
				 this->printToolStripMenuItem->Size = System::Drawing::Size(103, 22);
				 this->printToolStripMenuItem->Text = L"&Print";
				 this->printToolStripMenuItem->Click += gcnew System::EventHandler(this, &MyForm3::printToolStripMenuItem_Click);
				 // 
				 // exitToolStripMenuItem
				 // 
				 this->exitToolStripMenuItem->Name = L"exitToolStripMenuItem";
				 this->exitToolStripMenuItem->Size = System::Drawing::Size(103, 22);
				 this->exitToolStripMenuItem->Text = L"&Exit";
				 this->exitToolStripMenuItem->Click += gcnew System::EventHandler(this, &MyForm3::exitToolStripMenuItem_Click);
				 // 
				 // aboutToolStripMenuItem
				 // 
				 this->aboutToolStripMenuItem->Name = L"aboutToolStripMenuItem";
				 this->aboutToolStripMenuItem->Size = System::Drawing::Size(52, 20);
				 this->aboutToolStripMenuItem->Text = L"&About";
				 this->aboutToolStripMenuItem->Click += gcnew System::EventHandler(this, &MyForm3::aboutToolStripMenuItem_Click);
				 // 
				 // comboBox1
				 // 
				 this->comboBox1->FormattingEnabled = true;
				 this->comboBox1->Location = System::Drawing::Point(207, 38);
				 this->comboBox1->Name = L"comboBox1";
				 this->comboBox1->Size = System::Drawing::Size(84, 21);
				 this->comboBox1->TabIndex = 1;
				 // 
				 // label1
				 // 
				 this->label1->AutoSize = true;
				 this->label1->Font = (gcnew System::Drawing::Font(L"Microsoft Sans Serif", 9.75F, System::Drawing::FontStyle::Bold, System::Drawing::GraphicsUnit::Point,
					 static_cast<System::Byte>(0)));
				 this->label1->Location = System::Drawing::Point(12, 39);
				 this->label1->Name = L"label1";
				 this->label1->Size = System::Drawing::Size(189, 16);
				 this->label1->TabIndex = 2;
				 this->label1->Text = L"Select serial port for MFM:";
				 // 
				 // label2
				 // 
				 this->label2->AutoSize = true;
				 this->label2->Font = (gcnew System::Drawing::Font(L"Microsoft Sans Serif", 9.75F, System::Drawing::FontStyle::Bold, System::Drawing::GraphicsUnit::Point,
					 static_cast<System::Byte>(0)));
				 this->label2->Location = System::Drawing::Point(308, 40);
				 this->label2->Name = L"label2";
				 this->label2->Size = System::Drawing::Size(133, 16);
				 this->label2->TabIndex = 3;
				 this->label2->Text = L"Select Baud Rate:";
				 // 
				 // comboBox2
				 // 
				 this->comboBox2->FormattingEnabled = true;
				 this->comboBox2->Items->AddRange(gcnew cli::array< System::Object^  >(5) { L"9600", L"19200", L"38400", L"57600", L"115200" });
				 this->comboBox2->Location = System::Drawing::Point(447, 38);
				 this->comboBox2->Name = L"comboBox2";
				 this->comboBox2->Size = System::Drawing::Size(119, 21);
				 this->comboBox2->TabIndex = 4;
				 // 
				 // label5
				 // 
				 this->label5->AutoSize = true;
				 this->label5->Font = (gcnew System::Drawing::Font(L"Microsoft Sans Serif", 9.75F, System::Drawing::FontStyle::Bold, System::Drawing::GraphicsUnit::Point,
					 static_cast<System::Byte>(0)));
				 this->label5->Location = System::Drawing::Point(12, 69);
				 this->label5->Name = L"label5";
				 this->label5->Size = System::Drawing::Size(189, 20);
				 this->label5->TabIndex = 5;
				 this->label5->Text = L"Sampling interval:";
				 // 
				 // comboBox4
				 // 
				 this->comboBox4->FormattingEnabled = true;
				 this->comboBox4->Items->AddRange(gcnew cli::array< System::Object^  >(13) { L"200ms", L"250ms", L"333ms", L"500ms", L"1s", L"2s", L"3s", L"5s", L"10s", L"15s", L"20s", L"30s", L"60s" });
				 this->comboBox4->Location = System::Drawing::Point(207, 69);
				 this->comboBox4->Name = L"comboBox4";
				 this->comboBox4->Size = System::Drawing::Size(84, 21);
				 this->comboBox4->TabIndex = 6;
				 this->comboBox4->TextChanged += gcnew System::EventHandler(this, &MyForm3::SamplingIntervalChange);
				 // 
				 // checkBox1
				 // 
				 this->checkBox1->Location = System::Drawing::Point(307, 69);
				 this->checkBox1->AutoSize = true;
				 this->checkBox1->Font = (gcnew System::Drawing::Font(L"Microsoft Sans Serif", 9.75F, System::Drawing::FontStyle::Bold, System::Drawing::GraphicsUnit::Point,
					 static_cast<System::Byte>(0)));
				 this->checkBox1->Name = L"checkBox1";
				 this->checkBox1->Text = L"Live reading";
				 this->checkBox1->TabIndex = 7;
				 this->checkBox1->Click += gcnew System::EventHandler(this, &MyForm3::LiveReadingChange);
				 // 
				 // button1
				 // 
				 this->button1->BackColor = System::Drawing::Color::White;
				 this->button1->FlatStyle = System::Windows::Forms::FlatStyle::Flat;
				 this->button1->Font = (gcnew System::Drawing::Font(L"Microsoft Sans Serif", 12, System::Drawing::FontStyle::Bold, System::Drawing::GraphicsUnit::Point, static_cast<System::Byte>(0)));
				 this->button1->ForeColor = System::Drawing::Color::Red;
				 this->button1->Location = System::Drawing::Point(47, 107);
				 this->button1->Name = L"button1";
				 this->button1->Size = System::Drawing::Size(150, 49);
				 this->button1->TabIndex = 8;
				 this->button1->Text = L"Take a Sample";
				 this->button1->UseVisualStyleBackColor = false;
				 this->button1->Click += gcnew System::EventHandler(this, &MyForm3::button1_Click);
				 // 
				 // button2
				 // 
				 this->button2->BackColor = System::Drawing::Color::White;
				 this->button2->FlatStyle = System::Windows::Forms::FlatStyle::Flat;
				 this->button2->Font = (gcnew System::Drawing::Font(L"Microsoft Sans Serif", 12, System::Drawing::FontStyle::Bold, System::Drawing::GraphicsUnit::Point, static_cast<System::Byte>(0)));
				 this->button2->ForeColor = System::Drawing::Color::Red;
				 this->button2->Location = System::Drawing::Point(227, 107);
				 this->button2->Name = L"button1";
				 this->button2->Size = System::Drawing::Size(150, 49);
				 this->button2->TabIndex = 9;
				 this->button2->Text = L"Start Sampling";
				 this->button2->UseVisualStyleBackColor = false;
				 this->button2->Click += gcnew System::EventHandler(this, &MyForm3::button2_Click);
				 // 
				 // textBox1
				 // 
				 this->textBox1->AcceptsReturn = true;
				 this->textBox1->BackColor = System::Drawing::Color::White;
				 this->textBox1->BorderStyle = System::Windows::Forms::BorderStyle::FixedSingle;
				 this->textBox1->Font = (gcnew System::Drawing::Font(L"Microsoft Sans Serif", 12, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point,
					 static_cast<System::Byte>(0)));
				 this->textBox1->ForeColor = System::Drawing::Color::Black;
				 this->textBox1->Location = System::Drawing::Point(47, 174);
				 this->textBox1->Multiline = true;
				 this->textBox1->Name = L"textBox1";
				 this->textBox1->ReadOnly = true;
				 this->textBox1->ScrollBars = System::Windows::Forms::ScrollBars::Vertical;
				 this->textBox1->Size = System::Drawing::Size(853, 349);
				 this->textBox1->TabIndex = 10;
				 // 
				 // label3
				 // 
				 this->label3->AutoSize = true;
				 this->label3->Font = (gcnew System::Drawing::Font(L"Microsoft Sans Serif", 9.75F, System::Drawing::FontStyle::Bold, System::Drawing::GraphicsUnit::Point,
					 static_cast<System::Byte>(0)));
				 this->label3->Location = System::Drawing::Point(427, 124);
				 this->label3->Name = L"label3";
				 this->label3->Size = System::Drawing::Size(124, 16);
				 this->label3->TabIndex = 11;
				 this->label3->Text = L"Range Selected:";
				 // 
				 // textBox2
				 // 
				 this->textBox2->BorderStyle = System::Windows::Forms::BorderStyle::FixedSingle;
				 this->textBox2->Font = (gcnew System::Drawing::Font(L"Microsoft Sans Serif", 12, System::Drawing::FontStyle::Bold, System::Drawing::GraphicsUnit::Point,
					 static_cast<System::Byte>(0)));
				 this->textBox2->ForeColor = System::Drawing::Color::FromArgb(static_cast<System::Int32>(static_cast<System::Byte>(0)), static_cast<System::Int32>(static_cast<System::Byte>(192)),
					 static_cast<System::Int32>(static_cast<System::Byte>(0)));
				 this->textBox2->Location = System::Drawing::Point(557, 119);
				 this->textBox2->Name = L"textBox2";
				 this->textBox2->Size = System::Drawing::Size(343, 26);
				 this->textBox2->TabIndex = 12;
				 this->textBox2->TextAlign = System::Windows::Forms::HorizontalAlignment::Center;
				 // 
				 // openFileDialog1
				 // 
				 this->openFileDialog1->FileName = L"openFileDialog1";
				 // 
				 // label4
				 // 
				 this->label4->AutoSize = true;
				 this->label4->Font = (gcnew System::Drawing::Font(L"Microsoft Sans Serif", 9.75F, System::Drawing::FontStyle::Bold, System::Drawing::GraphicsUnit::Point,
					 static_cast<System::Byte>(0)));
				 this->label4->Location = System::Drawing::Point(585, 41);
				 this->label4->Name = L"label4";
				 this->label4->Size = System::Drawing::Size(227, 16);
				 this->label4->TabIndex = 13;
				 this->label4->Text = L"Select Load Impedance (ohms):";
				 // 
				 // comboBox3
				 // 
				 this->comboBox3->FormattingEnabled = true;
				 this->comboBox3->Items->AddRange(gcnew cli::array< System::Object^  >(9) { L"600", L"75", L"50", L"32", L"16", L"8", "6", L"4", L"2" });
				 this->comboBox3->Location = System::Drawing::Point(818, 40);
				 this->comboBox3->Name = L"comboBox3";
				 this->comboBox3->Size = System::Drawing::Size(82, 21);
				 this->comboBox3->TabIndex = 14;

				 // 
				 // printDialog1
				 // 
				 this->printDialog1->UseEXDialog = true;
				 // 
				 // MyForm
				 // 
				 this->AutoScaleDimensions = System::Drawing::SizeF(6, 13);
				 this->AutoScaleMode = System::Windows::Forms::AutoScaleMode::Font;
				 this->BackColor = System::Drawing::Color::FromArgb(static_cast<System::Int32>(static_cast<System::Byte>(255)), static_cast<System::Int32>(static_cast<System::Byte>(224)),
					 static_cast<System::Int32>(static_cast<System::Byte>(192)));
				 this->ClientSize = System::Drawing::Size(953, 546);
				 this->Controls->Add(this->comboBox3);
				 this->Controls->Add(this->comboBox4);
				 this->Controls->Add(this->checkBox1);
				 this->Controls->Add(this->label4);
				 this->Controls->Add(this->textBox2);
				 this->Controls->Add(this->label3);
				 this->Controls->Add(this->textBox1);
				 this->Controls->Add(this->button1);
				 this->Controls->Add(this->button2);
				 this->Controls->Add(this->comboBox2);
				 this->Controls->Add(this->label2);
				 this->Controls->Add(this->label1);
				 this->Controls->Add(this->comboBox1);
				 this->Controls->Add(this->menuStrip1);
				 this->Controls->Add(this->label5);
				 this->MainMenuStrip = this->menuStrip1;
				 this->Name = L"MyForm";
				 this->StartPosition = System::Windows::Forms::FormStartPosition::CenterScreen;	// <-- added
				 this->Text = L"Silicon Chip Multifunction Measuring System";
				 this->Load += gcnew System::EventHandler(this, &MyForm3::MyForm3_Load);
				 this->ResizeEnd += gcnew System::EventHandler(this, &MyForm3::MyForm3_ResizeEnd);
				 this->menuStrip1->ResumeLayout(false);
				 this->menuStrip1->PerformLayout();
				 this->ResumeLayout(false);
				 this->PerformLayout();
			 }
#pragma endregion

			 // ------------------------------------------------------------------------------------
			 // PROGRAM CODE NOW BEGINS
			 // -------------------------------------------------------------------------------------

			 // find available serial ports & make visible in comboBox1 list
	private: void findPorts(void)
	{
		// first get the names of available ports
		array<Object^ > ^ objectArray = System::IO::Ports::SerialPort::GetPortNames();
		// then add the string array to the items list for comboBox1
		this->comboBox1->Items->Clear();
		this->comboBox1->Items->AddRange(objectArray);
	}

			 // ---------------------------------------------------------------------------------------
			 //	function to perform specialised scaling for AF LvL & Power range (range 1)

	private: String^ AFLvlScaling(float SampleValue)
	{
		double dBraw, dBmLevel = 0, dBVLevel, VoltsRMS, PwrWatts = 0, DivLogV;
		Int32 Impedance = 0;
		String^ SamString;

		dBraw = 50.0000 * SampleValue;	// first multiply SampleValue by 50 to get
										// the dBraw level, since in this circuit the output from the AD8307 follows
										// a law of 20mV/dB. So 2.500V becomes equivalent to 125dBraw.

		dBVLevel = dBraw - 89.43697499;	// then get the equivalent dBV level
										// by subtracting (125 - 35.56302501 = 89.43697499), since
										// 125dBraw = 60.00V = +35.56302501dBV (0dBV = 1.000V)

										// next work out the RMS AF input voltage
		DivLogV = dBVLevel / 20.0000;			// first by dividing by 20
		DivLogV = DivLogV * 2.302585093;		// then multiplying by ln(10)
		VoltsRMS = Math::Exp(DivLogV);		// so we can take the antilog (10^DivLogV)
											// (the Exp() function works out the natural exponent e^())

		// if so, get the impedance level that has been selected
		try {
			Impedance = Int32::Parse(this->comboBox3->Text);
			if (Impedance > 0) {
				dBmLevel = dBraw - 125 + Math::Log10(60 * 60 * 1000 / Impedance) * 10;
				PwrWatts = (VoltsRMS * VoltsRMS) / Impedance;
			}
		} catch( ... ) {
		}

		// and finally assemble the sample data string
		SamString = dBVLevel.ToString("#0.0000") + "dBV; ";
		SamString += VoltsRMS.ToString("#0.0000") + "Vrms; ";
		if (Impedance > 0) {
			SamString += dBmLevel.ToString("#0.0000") + "dBm; ";
			SamString += PwrWatts.ToString("###0.00##") + "W";
		}
		else {
			SamString += "ERRdBm; ERRW";
		}
		return SamString;
	}	// end of AF Lvl & Power scaling function

		// --------------------------------------------------------------------------
		// function to perform specialised scaling for RF Lvl & Power range (range 2)

	private: String^ RFLvlScaling(float SampleValue)
	{
		double dBraw, dBVLevel, dBmLevel = 0, PwrWatts = 0, VoltsRMS, DivLogV;
		Int32 Impedance;
		String^ SamString;

		dBraw = 40.0000 * SampleValue;	// first multiply SampleValue by 40 to get
										// the dBraw level, since in the RF head end the output from the AD8307
										// follows a law of 25mV/dB. So 0 - 2.500V becomes a range of 0-100dBraw.

		dBVLevel = dBraw - 53.01029996;	// then get the equivalent dBV level by
										// subtracting (100 - 46.98970004 = 53.01029996), since
										// 100dBraw = 223.6067977V = 46.98970004dBV (0dBV = 1.00V) 

										// next work out the RMS RF input voltage
		DivLogV = dBVLevel / 20.0000;		// first by dividing by 20
		DivLogV = DivLogV * 2.302585093;	// then multiplying by ln(10)
		VoltsRMS = Math::Exp(DivLogV);		// so we can take the antilog (10^DivLogV)
											// (the Exp() function works out the natural exponent e^())

											// then check that the impedance level has been selected by the user
		if (this->comboBox3->Text == String::Empty)
		{
			MessageBox::Show("Please Select Impedance level!", "Impedance Level Not Set", MessageBoxButtons::OK);
			return "";
		}
		// if so, get the impedance level that has been selected
		try {
			Impedance = Int32::Parse(this->comboBox3->Text);
			if (Impedance > 0) {
				dBmLevel = dBraw - 100 + Math::Log10(50000 * 1000 / Impedance) * 10;
				PwrWatts = (VoltsRMS * VoltsRMS) / Impedance;
			}
		} catch (...) {
		}

		// and finally assemble the sample data string
		SamString = dBVLevel.ToString("#0.00000") + "dBV; ";
		SamString += VoltsRMS.ToString("##0.0000") + "Vrms; ";
		if (Impedance > 0) {
			SamString += dBmLevel.ToString("#0.00000") + "dBm; ";
			SamString += PwrWatts.ToString("####0.000") + "W";
		}
		else {
			SamString += "ERRdBm; ERRW";
		}
		return SamString;
	}	// end of RF Lvl & Power scaling function

		// -------------------------------------------------------------------------
		// 'File>Open' toolstrip menu item click event function

	private: static bool StringIsNum(String^ pString) {
		for (int i = 0; i < pString->Length; ++i)
			if (pString[i] < '0' || pString[i] > '9')
				return false;
		return pString->Length > 0;
	}
	private: System::Void openToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e)
	{
		Int16 i = 0;	// counter for the for loop
		openFileDialog1->FileName = "MyMFMSampleFile1";
		openFileDialog1->DefaultExt = "mfm";
		openFileDialog1->Filter = "CSV files (*.csv)|*.csv|All files (*.*)|*.*";
		DialogResult = openFileDialog1->ShowDialog();	// show the openfile dialog box
		if (DialogResult == System::Windows::Forms::DialogResult::OK)	// check if result = OK
		{
			String^ filename = openFileDialog1->FileName;
			StreamReader^ sr;
			try {
				sr = gcnew StreamReader(filename);	// open the file for reading
			} catch (Exception^ e) {
				MessageBox::Show("Error opening file: " + e->Message, "Silicon Chip Multifunction Meter", MessageBoxButtons::OK);
				return;
			}
			String^ line;
			String^ newtext;
			while (line = sr->ReadLine()) {
				try {
					if (line->EndsWith(L"\r"))
						line = line->Substring(0, line->Length - 1);
					array<String^>^ fields = line->Split(L',');
					if (fields->Length != 7)
						continue;

					if (fields[1] == "SerialPort") {
						this->comboBox1->Text = fields[2];
					}
					else if (fields[1] == "BaudRate") {
						this->comboBox2->Text = fields[2];
					}
					else if (fields[1] == "InitialRange") {
						this->textBox2->Text = fields[2];
					}
					else if (fields[1] == "Impedance") {
						this->comboBox3->Text = fields[2];
					}
					else if (fields[1] == "InitialSamplingRate") {
						this->comboBox4->Text = fields[2];
					}
					else if (fields[1] == "TotalSamples") {
					}
					else if (fields[1] == "Open") {
						if (fields[4] != "")
							newtext += fields[0] + ": " + "Open serial port " + fields[2] + " at " + fields[3] + "bps for sampling every " + fields[4] + "... " + fields[5] + "." + Environment::NewLine;
						else
							newtext += fields[0] + ": " + "Open serial port " + fields[2] + " at " + fields[3] + "bps for single sample... " + fields[5] + "." + Environment::NewLine;
					}
					else if (fields[1] == "Close") {
						newtext += fields[0] + ": " + "Closed serial port." + Environment::NewLine;
					}
					else if (StringIsNum(fields[1])) {
						if (fields[6] == "") {
							// 19/02/2016 10:01:38 AM: 1.23V
							newtext += fields[0] + ": " + fields[3] + "V" + Environment::NewLine;
						}
						else {
							// 19/02/2016 10:01:38 AM: -89.3702dBV; Vrms; -87.1517dBm; 0W
							newtext += fields[0] + ": " + fields[3] + "dBV; " + fields[4] + "Vrms; " + fields[5] + "dBm; " + fields[6] + "W" + Environment::NewLine;
						}
					}
				} catch (...) {
				}
			}
			this->textBox1->Text = newtext;
			sr->Close();	// before closing the stream
		}
	}

			 // -------------------------------------------------------------------------
			 // 'File>Save' toolstrip menu item click event function

	private: System::Void saveToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e)
	{
		saveFileDialog1->CreatePrompt = false;
		saveFileDialog1->OverwritePrompt = true;
		saveFileDialog1->FileName = "MyMFMSampleFile1";
		saveFileDialog1->DefaultExt = "csv";
		saveFileDialog1->Filter = "CSV files (*.csv)|*.csv|All files (*.*)|*.*";
		DialogResult = saveFileDialog1->ShowDialog();	// show the saveFile dialog box
		if (DialogResult == System::Windows::Forms::DialogResult::OK)
		{
			String^ filename = saveFileDialog1->FileName;
			StreamWriter^ sw;
			try {
				sw = gcnew StreamWriter(filename);	// open the file for writing
			} catch (Exception^ e) {
				MessageBox::Show("Error writing to file: " + e->Message, "Silicon Chip Multifunction Meter", MessageBoxButtons::OK);
				return;
			}
			String^ now = DateTime::Now.ToString("dd/MM/yy HH:mm:ss.fff");
			int CurrentFormat = 0;

			try {
				sw->WriteLine("Timestamp,Config,Value,,,,");
				sw->WriteLine(now + ",SerialPort," + this->comboBox1->Text + ",,,,");
				sw->WriteLine(now + ",BaudRate," + this->comboBox2->Text + ",,,,");
				sw->WriteLine(now + ",InitialRange," + this->textBox2->Text + ",,,,");
				sw->WriteLine(now + ",Impedance," + this->comboBox3->Text + ",,,,");
				sw->WriteLine(now + ",InitialSamplingRate," + this->comboBox4->Text + ",,,,");
				sw->WriteLine(now + ",TotalSamples," + SintBox1 + ",,,,");
				array<String^>^ lines = this->textBox1->Text->Split(L'\n');
				int SampleNum = 0;
				DateTime^ startdatetime = gcnew System::DateTime;
				for (int i = 0; i < lines->Length; ++i) {
					String^ line = lines[i];
					if (line->EndsWith(L"\r"))
						line = line->Substring(0, line->Length - 1);
					if (line->Length == 0)
						continue;

					array<String^>^ fields = line->Split(L':');
					for (int j = 1; j < fields->Length - 1; ++j)
						fields[0] += ":" + fields[j];
					fields[1] = fields[fields->Length - 1]->Substring(1);

					if (fields[1]->StartsWith("Open")) {
						// 19/02/2016 10:01:38 AM: Open serial port <PORT> at <BAUD>bps for sampling every <x>s... (succeeded|failed).
						if (CurrentFormat != 1) {
							sw->WriteLine("Timestamp,Event,Port,Baud,Sampling Rate,Result,");
							CurrentFormat = 1;
						}
						array<String^>^ words = fields[1]->Split(L' ');
						if( words->Length == 11 )
							sw->WriteLine(fields[0] + ",Open," + words[3] + "," + words[5]->Substring(0, words[5]->Length - 3) + "," + words[9]->Substring(0, words[9]->Length-3) + "," + words[10]->Substring(0, words[10]->Length - 1) + ",");
						else
							sw->WriteLine(fields[0] + ",Open," + words[3] + "," + words[5]->Substring(0, words[5]->Length - 3) + ",," + words[9]->Substring(0, words[9]->Length - 1)+",");
						SampleNum = 0;
					}
					else if (fields[1]->StartsWith("Close")) {
						// 19/02/2016 10:01:38 AM: Closed serial port.
						if (CurrentFormat != 1) {
							sw->WriteLine("Timestamp,Event,Port,Baud,Sampling Rate,Result,");
							CurrentFormat = 1;
						}
						sw->WriteLine(fields[0] + ",Close,,,,,");
						SampleNum = 0;
					}
					else if (fields[1]->EndsWith("W")) {
						// 19/02/2016 10:01:38 AM: -89.3702dBV; Vrms; -87.1517dBm; 0W
						System::DateTime^ datetime;

						if (CurrentFormat != 2) {
							sw->WriteLine("Timestamp,SampleNum,SampleTimeSecs,dBV,Vrms,dBm,W");
							CurrentFormat = 2;
						}
						try {
							datetime = System::DateTime::Parse(fields[0]);
						}
						catch (...) {
							datetime = System::DateTime::Now;
						}
						if (SampleNum == 0)
							*startdatetime = *datetime;

						array<String^>^ data = fields[1]->Split(L';');
						data[1] = data[1]->Substring(1);
						data[2] = data[2]->Substring(1);
						data[3] = data[3]->Substring(1);
						sw->WriteLine(fields[0] + "," + SampleNum + "," + ((*datetime - *startdatetime).TotalMilliseconds / 1000.0) + "," + data[0]->Substring(0, data[0]->Length-3) + "," + data[1]->Substring(0, data[1]->Length-4) + "," + data[2]->Substring(0, data[2]->Length-3) + "," + data[3]->Substring(0, data[3]->Length-1));
						++SampleNum;
					}
					else {
						// 19/02/2016 10:01:38 AM: 1.23V
						System::DateTime^ datetime;

						if (CurrentFormat != 3) {
							sw->WriteLine("Timestamp,SampleNum,SampleTimeSecs,Voltage,,,");
							CurrentFormat = 3;
						}
						try {
							datetime = System::DateTime::Parse(fields[0]);
						}
						catch (...) {
							datetime = System::DateTime::Now;
						}
						if (SampleNum == 0)
							*startdatetime = *datetime;

						sw->WriteLine(fields[0] + "," + SampleNum + "," + ((*datetime - *startdatetime).TotalMilliseconds / 1000.0) + "," + fields[1]->Substring(0, fields[1]->Length - 1) + ",,,");
						++SampleNum;
					}
				}
				sw->Close();							// and finally close the file
			} catch (Exception^ e) {
				MessageBox::Show("Error writing to file: " + e->Message, "Silicon Chip Multifunction Meter", MessageBoxButtons::OK);
				return;
			}
		}
	}

			 // ----------------------------------------------------------------------------------
			 // 'File>Exit' toolstrip menu item click event function
	private: System::Void exitToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e)
	{
		System::Windows::Forms::DialogResult buttonClicked;
		buttonClicked = MessageBox::Show("Sure you want to exit?", "Verify Exit", MessageBoxButtons::YesNo);
		if (buttonClicked == System::Windows::Forms::DialogResult::Yes)
			this->Close();
	}
			 // -----------------------------------------------------------------------------------
			 // 'About' toolstrip menu item click event function

	private: System::Void aboutToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e)
	{
		String^Message = "Silicon Chip Arduino based Multifunction Meter App V1.1" + "\nWritten by Jim Rowe and Nicholas Vinen" + "\nDec 2015 - March 2016";
		MessageBox::Show(Message, "Silicon Chip Multifunction Meter", MessageBoxButtons::OK);
	}
			 // ------------------------------------------------------------------------------------

	private: System::Void MyForm3_Load(System::Object^  sender, System::EventArgs^  e)
	{

	}

	private: System::Void MyForm3_ResizeEnd(System::Object^  sender, System::EventArgs^  e)
	{
		this->textBox1->Size = System::Drawing::Size(this->ClientRectangle.Width - 100, this->ClientRectangle.Height - 197);
	}

    // ----------------------------------------------------------------------------------------
	// Function to get current position of S1b on MFM shield PCB (saved as S1bSwPosition)
	// & then get a raw sample reading from the MFM & save in SampleValue.

	private: bool FetchSample(float* pSample, int* pS1bSwPosition)
	{
		int tries = 3;

		if (!this->serialPort1->IsOpen)
		{
			this->serialPort1->Open();	// first open the serial port if not already open
			this->serialPort1->ReadTimeout = 500;
			this->serialPort1->WriteTimeout = 500;
		}

		while(1) {
			array<String^>^ fields;
			this->serialPort1->WriteLine("b");
			try {
				fields = this->serialPort1->ReadLine()->Split(L' ');
			} catch (TimeoutException^) {
				MessageBox::Show("Port not responding", "Timeout Exception", MessageBoxButtons::OK);
				return false;
			}
			if (fields->Length == 2) {
				try {
					*pS1bSwPosition = Int16::Parse(fields[0]);
				} catch (...) {
					MessageBox::Show("Invalid data received from unit", "Data parse error", MessageBoxButtons::OK);
					return false;
				}
				if (*pS1bSwPosition == 0) {
					if (--tries == 0) {
						*pSample = 0;
						return false;
					}
					continue;
				}

				try {
					*pSample = (float)Double::Parse(fields[1]);
				} catch (...) {
					MessageBox::Show("Invalid data received from unit", "Data parse error", MessageBoxButtons::OK);
					return false;
				}
				return true;
			}
			return false;
		}
	}	// end of FetchSample function

		// -------------------------------------------------------------------------------------
		// function to process sample data after a sample has been received
	private: void ProcessSample(float SampleValue, int S1bSwPosition, bool LiveReadingOnly)
	{
		String^ SamString;

		switch (S1bSwPosition)
		{
		case 1:
			this->textBox2->Text = "AF Level & Power";
			SamString = AFLvlScaling(SampleValue);
			break;
		case 2:
			this->textBox2->Text = "RF Level & Power";
			SamString = RFLvlScaling(SampleValue);
			break;
		case 3:
			this->textBox2->Text = "DC volts (0 - 2.50V)";
			// 2.5V range, so leave this value unchanged
			SamString = SampleValue.ToString("0.00###") + "V";
			break;
		case 4:
			this->textBox2->Text = "DC volts (0 - 25.0V)";
			SampleValue *= 10.000f;	// 25V range, so multiply by 10
			SamString = SampleValue.ToString("#0.0###") + "V";
			break;
		case 5:
			this->textBox2->Text = "DC volts (0 - 250.0V)";
			SampleValue *= 100.000f;	// 250V range, so multiply by 100
			SamString = SampleValue.ToString("##0.0##") + "V";
			break;
		case 6:
			this->textBox2->Text = "DC volts (0 - 1000V)";
			SampleValue *= 400.000f;	// 1000V range, so multiply by 400
			SamString = SampleValue.ToString("###0.##") + "V";
			break;
		default:
			this->textBox2->Text = "Error reading switch";
			break;
		}

		if( LiveReadingOnly ) {
			if( this->checkBox1->Checked )
				this->checkBox1->Text = L"Live reading: " + SamString;
		} else {
			if( this->LiveReading && this->checkBox1->Checked )
				this->checkBox1->Text = L"Live reading: " + SamString;

			if (this->SerialPortOpen) {
				// and display sample value value in textBox1
				SamString = DateTime::Now.ToString("dd/MM/yy HH:mm:ss.fff") + ": " + SamString + Environment::NewLine;

				this->textBox1->Text += SamString;	// adding the new string to any previous lines
				this->textBox1->SelectionStart = this->textBox1->TextLength;
				this->textBox1->ScrollToCaret();
				++SintBox1;		// and incrementing count of samples in textBox1
			}
		}
	}

#define MSG_SERIAL_OPEN_START 1
#define MSG_SERIAL_OPEN_ERROR 2
#define MSG_SERIAL_OPEN_OK    3
#define MSG_SERIAL_CLOSE      4

	protected: virtual void WndProc(System::Windows::Forms::Message %m) override
	{
//#define WM_USER 0x0400
		if( m.Msg == WM_USER || m.Msg == WM_USER+1 ) {
			ProcessSample(*((float*)&m.WParam), (int)m.LParam, m.Msg == WM_USER+1);
		}
		else if (m.Msg == WM_USER + 2) {
			switch ((int)m.LParam) {
			case MSG_SERIAL_OPEN_START:
				if (this->ContSampling)
					this->textBox1->Text += DateTime::Now.ToString("dd/MM/yy HH:mm:ss.fff") + ": " + "Open serial port " + this->serialPort1->PortName + " at " + this->serialPort1->BaudRate + "bps for sampling every " + this->comboBox4->Text + "...";
				else
					this->textBox1->Text += DateTime::Now.ToString("dd/MM/yy HH:mm:ss.fff") + ": " + "Open serial port " + this->serialPort1->PortName + " at " + this->serialPort1->BaudRate + "bps for single sample...";
				break;
			case MSG_SERIAL_OPEN_ERROR:
				this->textBox1->Text += " failed." + Environment::NewLine;
				this->button2->Text = "Start Sampling";	// restore button2 text
				break;
			case MSG_SERIAL_OPEN_OK:
				this->textBox1->Text += " succeeded." + Environment::NewLine;
				this->SerialPortOpen = true;
				break;
			case MSG_SERIAL_CLOSE:
				if (this->SuppressCloseMessage) {
					this->SuppressCloseMessage = false;
				} else {
					this->SerialPortOpen = false;
					this->textBox1->Text += DateTime::Now.ToString("dd/MM/yy HH:mm:ss.fff") + ": " + "Closed serial port." + Environment::NewLine;
					if( !this->LiveReading )
						this->button2->Text = "Start Sampling";	// restore button2 text
				}
				break;
			}
		}
		else if (m.Msg == WM_DEVICECHANGE) {
			findPorts();
		}
		else if (m.Msg == WM_CLOSE) {
			OnClose();
		}
		Form::WndProc(m);
	}
	private: System::Void samplingThreadLoop(void)
	{
		ULONGLONG old_timer, new_timer;
		int delta;

		try {
			// open serial port if it isn't already open
			if (!this->serialPort1->IsOpen)
			{
				// and open the serial port
				if( !this->LiveReadingOnly )
					PostMessage(myHWND, WM_USER + 2, 0, MSG_SERIAL_OPEN_START);
				this->serialPort1->Open();
				if (!this->LiveReadingOnly)
					PostMessage(myHWND, WM_USER + 2, 0, MSG_SERIAL_OPEN_OK);
			}
		}
		catch (UnauthorizedAccessException^)
		{
			if (!this->LiveReadingOnly)
				PostMessage(myHWND, WM_USER + 2, 0, MSG_SERIAL_OPEN_ERROR);
			SampActive = false;
			MessageBox::Show("Unauthorised Access", "Unauthorised Access", MessageBoxButtons::OK);
			return;
		}
		catch (Exception^ e)
		{
			if (!this->LiveReadingOnly)
				PostMessage(myHWND, WM_USER + 2, 0, MSG_SERIAL_OPEN_ERROR);
			SampActive = false;
			MessageBox::Show(e->Message, "Sampling Error", MessageBoxButtons::OK);
			return;
		}

		old_timer = GetTickCount64();
		while( SampActive && !AbortSampling ) {
			bool success;
			float sample;
			int S1bSwPosition;
			int SamplingInterval;

			success = FetchSample(&sample, &S1bSwPosition);
			if (success)
				PostMessage(myHWND, this->LiveReadingOnly ? WM_USER + 1 : WM_USER, *((WPARAM*)&sample), (LPARAM)S1bSwPosition);
			if( !ContSampling )
				break;
			while ( SampActive && !AbortSampling ) {
				new_timer = GetTickCount64();
				SamplingInterval = this->SamplingIntervalMilliseconds;
				delta = (int)(old_timer + SamplingInterval - new_timer);
				if (delta > 250)
					delta = 250;
				if( delta > 0 && delta < SamplingInterval*2 )
					System::Threading::Thread::Sleep(delta);	// pause for 500ms
				else
					break;
			}
			old_timer += SamplingInterval;
			if (GetTickCount64() - old_timer > 500)
				old_timer = GetTickCount64();
		}
		if (!this->LiveReadingOnly)
			PostMessage(myHWND, WM_USER + 2, 0, MSG_SERIAL_CLOSE);
		this->serialPort1->Close();		// close the serial port
		SampActive = false;
	}	// end of samplingThreadLoop() function

	private: System::Void StartSampling() {
		this->AbortSampling = false;
		if( this->ContSampling && !this->LiveReadingOnly )
			this->button2->Text = L"Stop Sampling";	// first changing button1 text
		if( this->samplingThread && this->samplingThread->IsAlive ) {
			if (this->SampActive)
				return;
			this->samplingThread->Abort();
		}
		this->SampActive = true;
		this->samplingThread = gcnew System::Threading::Thread(gcnew System::Threading::ThreadStart(this, &MyForm3::samplingThreadLoop));
		// now set the serial port's PortName property
		this->serialPort1->PortName = this->comboBox1->Text;
		// and its BaudRate property
		try {
			this->serialPort1->BaudRate = Int32::Parse(this->comboBox2->Text);
		}
		catch (...) {
			this->serialPort1->BaudRate = 115200;
		}
		try {
			if (this->comboBox4->Text->EndsWith("ms"))
				this->SamplingIntervalMilliseconds = Int32::Parse(this->comboBox4->Text->Substring(0, this->comboBox4->Text->Length - 2));
			else
				this->SamplingIntervalMilliseconds = (int)(Double::Parse(this->comboBox4->Text->Substring(0, this->comboBox4->Text->Length - 1)) * 1000);
		}
		catch (...) {
		}
		this->samplingThread->Start();
	}

	private: System::Void StopSampling() {
		if( this->samplingThread && this->samplingThread->IsAlive ) {
			if( this->SampActive )
				this->AbortSampling = true;
		}
		this->button2->Text = "Start Sampling";	// restore button2 text
	}

		// ----------------------------------------------------------------------------------------------
			 // 'Start or Stop Sampling' button click event function
	private: System::Void button1_Click(System::Object^  sender, System::EventArgs^  e)
	{
		if (this->comboBox1->Text == String::Empty || this->comboBox2->Text == String::Empty) {
			MessageBox::Show("Please Select Port & Baud Rate!", "Port Settings Not Made", MessageBoxButtons::OK);
			return;
		}

		if (this->LiveReadingOnly) {
			StopSampling();
			while (this->SampActive)
				System::Threading::Thread::Sleep(10);
			this->LiveReadingOnly = false;
			this->LiveReading = true;
		}

		if (SampActive != true) {
			this->ContSampling = false;
			StartSampling();

			if (this->LiveReading) {
				while (this->SampActive)
					System::Threading::Thread::Sleep(10);
				this->LiveReading = false;

				this->LiveReadingOnly = true;
				this->ContSampling = true;
				StartSampling();
			}
		}
	}	//  before leaving  the 'Start or Stop Sampling' button click event

	private: System::Void LiveReadingChange(System::Object^  sender, System::EventArgs^  e) {
		if (this->SampActive && !this->LiveReadingOnly) {
			this->LiveReading = this->checkBox1->Checked;
			if (!this->LiveReading)
				this->checkBox1->Text = L"Live reading";
		}
		else {
			if (this->checkBox1->Checked) {
				this->LiveReadingOnly = true;
				this->ContSampling = true;
				StartSampling();
			}
			else {
				StopSampling();
				this->SuppressCloseMessage = true;
				this->LiveReadingOnly = false;
				this->checkBox1->Text = L"Live reading";
			}
		}
	}
	private: System::Void SamplingIntervalChange(System::Object^  sender, System::EventArgs^  e) {
		try {
			if (this->comboBox4->Text->EndsWith("ms"))
				this->SamplingIntervalMilliseconds = Int32::Parse(this->comboBox4->Text->Substring(0, this->comboBox4->Text->Length - 2));
			else
				this->SamplingIntervalMilliseconds = (int)(Double::Parse(this->comboBox4->Text->Substring(0, this->comboBox4->Text->Length - 1)) * 1000);
		}
		catch (...) {
		}
	}

	private: System::Void button2_Click(System::Object^  sender, System::EventArgs^  e)
	{
		// first check if sampling is already active, in which case user must want to stop
		if (SampActive == true && !this->LiveReadingOnly)
		{
			if (this->ContSampling) {
				StopSampling();
				if (this->LiveReading) {
					while (this->SampActive)
						System::Threading::Thread::Sleep(10);
					this->LiveReading = false;

					this->LiveReadingOnly = true;
					this->ContSampling = true;
					StartSampling();
				}
			}
			return;		// and bail out of this event function
		}
		else if (this->comboBox1->Text == String::Empty || this->comboBox2->Text == String::Empty) {
			MessageBox::Show("Please Select Port & Baud Rate!", "Port Settings Not Made", MessageBoxButtons::OK);
			return;
		}
		else {
			if (this->LiveReadingOnly) {
				StopSampling();
				while (this->SampActive)
					System::Threading::Thread::Sleep(10);
				this->LiveReadingOnly = false;
				this->LiveReading = true;
			}
			this->ContSampling = true;
			StartSampling();
		}
	}	//  before leaving  the 'Start or Stop Sampling' button click event

		// ----------------------------------------------------------------------------------
		// 'File>New' ToolStrip menu item click event
	private: System::Void newToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e)
	{
		System::Windows::Forms::DialogResult buttonClicked;
		buttonClicked = MessageBox::Show("Sure you want to begin again?", "Verify New Start", MessageBoxButtons::YesNo);
		if (buttonClicked == System::Windows::Forms::DialogResult::Yes)
		{
			ContSampling = false;			// reset to Single sampling
			SintBox1 = 0;				// clear samples count
			this->textBox1->Text = String::Empty;	// wipe text from textBox1
			this->textBox2->Text = String::Empty;	// and also from textBox2
		}
	}

			 // ----------------------------------------------------------------------
			 // function to allow printing text in textBox1, to one or more pages
	private: void printDocument1_PrintPage(Object^sender, PrintPageEventArgs^ e)
	{
		int charactersOnPage = 0;
		int linesPerPage = 0;

		// sets the value of charactersOnPage to the number of characters of
		// stringToPrint that will fit within the bounds of the page
		e->Graphics->MeasureString(this->stringToPrint, this->fontToUse, e->MarginBounds.Size, StringFormat::GenericTypographic, charactersOnPage, linesPerPage);

		// Draws the string within the bounds of the page
		e->Graphics->DrawString(stringToPrint, this->fontToUse, Brushes::Black, e->MarginBounds, StringFormat::GenericTypographic);

		// Remove the portion of the string that has been printed
		this->stringToPrint = this->stringToPrint->Substring(charactersOnPage);

		// finally check to see if more pages are to be printed
		e->HasMorePages = (this->stringToPrint->Length > 0);
	}

			 // ----------------------------------------------------------------------
			 // 'File>Print' ToolStrip menu item click event
	private: System::Void printToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e)
	{
		System::Drawing::Printing::PrintDocument^ docToPrint = gcnew System::Drawing::Printing::PrintDocument;
		this->stringToPrint = this->textBox1->Text;
		if (!this->fontToUse)
			this->fontToUse = gcnew System::Drawing::Font("Arial", 9.0f, System::Drawing::FontStyle::Regular);
		docToPrint->PrintPage += gcnew PrintPageEventHandler(this, &MyForm3::printDocument1_PrintPage);

		printDialog1->AllowSomePages = false;
		printDialog1->ShowHelp = true;
		printDialog1->AllowSelection = true;
		printDialog1->AllowCurrentPage = true;
		printDialog1->Document = docToPrint;
		//printDialog1->PrinterSettings->DefaultPageSettings->Portrait = true;

		// show the print dialog box & allow user to select, etc.
		System::Windows::Forms::DialogResult result = printDialog1->ShowDialog();

		// if the result from the print dialog box is OK, print the document
		if (result == System::Windows::Forms::DialogResult::OK)
			docToPrint->Print();
	}

	};	// end of MyForm3
}
